//		nexttrain			JavaScript 
//		時刻表データを持ってきて画面にセットする。
//		随時呼び出して使う
//		
//			if(window.widget){
//					g_timelimit = widget.preferenceForKey("ds_timelimit"); 
//			}
//		widgetでしか使えない関数の場合はifの中に入れておいた方がいいのかな？
//		ブラウザでデバッグしやすいのかもしれない。
// 
//		May , 2005

function nexttrain()
{
	var dbg1 = "DBG : " ;
	var tabledata = new Array;
	var ds_timetable = "../TEST.TBL";  //   <--  TEST用データ
	var ds_timelimit = 0 ;
	
	var elem = document.getElementById("back_timepopup") ;
	var ds_timelimit = elem.options[elem.selectedIndex].value ;
	var elem = document.getElementById("back_filepopup") ;
	var ds_timetable = elem.options[elem.selectedIndex].value ;
	ds_timetable = "./tables/" + ds_timetable ;
	
	// 現在の曜日を取得(ただし3時までは前日,
	// 取得して使うのは平日、休日、祝日、土曜の区分のみ)
	var nowdate = new Date;
	nowdate.setHours(nowdate.getHours() - 3) ;
	var myday = whatday(nowdate); 
	// myday = Sunday (0) , weekday(1,2,3,4,5) , saturday(6) , holiday (7)
	document.getElementById("ColorRect").style.backgroundColor = daycolor(myday);
	document.getElementById("wdaystr").innerText = daystr(myday) ;
	dbg1 = dbg1 + " ds_timelimit : " + ds_timelimit + ", ds_timetable : " + ds_timetable + ", myday : " + myday ;
	
	// 現在の時刻
	// 上で3引いたのでここで3足して元に戻す
	// 分には駅までの時間を足す
	// 後の計算に使うだけの値なので59+3=62になっても大丈夫
	var myhh = nowdate.getHours() + 3 ;
	var mymm = nowdate.getMinutes() + Number(ds_timelimit) ;
	//
	dbg1 =  myhh + ":" + nowdate.getMinutes() + dbg1 ;
	// document.getElementById("debugstr").innerText = dbg1 ;  // debug

	// perl で作成したNextTrain の処理(三件返ってくる)
	// $ /usr/bin/perl   ./gettabledata.pl   ./tables/CHOFUu1.txt   0   20  08 
	//  CHOFUu1.txt を使って日曜日の20時8分以降の直近三件のデータを取る
	// コマンドを入れる時はパラメータの区切りのスペースは1個じゃないとエラーかも？
	if(window.widget){
		var command = "/usr/bin/perl ./gettabledata.pl " + ds_timetable  + " " + myday + " " + myhh + " " + mymm ;
		var returndata = widget.system(command,null).outputString ;
		//
		/* var returnerror = widget.system(command,null).errorString ;
		if (returnerror) {  // debug
			dbg1 =  "command : " + command +  ", system error :" + returnerror + ", " + dbg1 ;
			document.getElementById("debugstr").innerText = dbg1 ; 
		}
		*/
		if (returndata) {  // debug
			dbg1 =  "command : " + command + " ,return : " + returndata  + ", " + dbg1 ;
			document.getElementById("debugstr").innerText = dbg1 ; 
		}
		// 返ってきた値はカンマ区切りでつながった12個のデータ
		// 分割して画面にそれぞれセットする。
		tabledata = returndata.split(",") ;
	}
	
	document.getElementById("df1tr").innerText = tabledata[0] ;
	document.getElementById("df1hh").innerText = tabledata[1] ;
	document.getElementById("df1mm").innerText = tabledata[2] ;
	document.getElementById("df1to").innerText = tabledata[3] ;
	document.getElementById("df1tr").style.color = traincolor(tabledata[0]) ;
	
	
	document.getElementById("df2tr").innerText = tabledata[4] ;
	document.getElementById("df2hh").innerText = tabledata[5] ;
	document.getElementById("df2mm").innerText = tabledata[6] ;
	document.getElementById("df2to").innerText = tabledata[7] ;
	document.getElementById("df2tr").style.color = traincolor(tabledata[4]) ;

	document.getElementById("df3tr").innerText = tabledata[8] ;
	document.getElementById("df3hh").innerText = tabledata[9] ;
	document.getElementById("df3mm").innerText = tabledata[10] ;
	document.getElementById("df3to").innerText = tabledata[11] ;
	document.getElementById("df3tr").style.color = traincolor(tabledata[8]) ;
	
	// 最後にリターンとして一番目のデータの時、分
	// 0:00〜2:59 は24:00〜26:59とする。
	// ゼロ件の時は次の更新時刻は午前三時となるので
	// 3*60 = 180 を返す
	// つまり180未満の時は60*24をプラス
	// 時 tabledata[1] ;
	// 分 tabledata[2] ;
	
	var return_time = 0 ;
	var hh = Number(tabledata[1]);
	var mm = Number(tabledata[2]);
	
	if( tabledata[1]  == " " ){
		// スペースが送られてくる時は終電後。
		// 次の更新時刻は午前3:00
		return_time = 3 * 60 + 0 ; //  3:00 AM
	}else{
		return_time = hh  * 60 + mm ;
		if (return_time < ( 3 * 60 + 0 ) ){
			return_time += ( 24 * 60 ) ;
		}
	}
	return  return_time ;
};



function whatday(wday)
{
	// 日付が祝日かどうかをチェックする
	// 祝日ダイヤ対応のため。
	// OSでは祝日情報を持っていないので自分で処理する
	// また年末年始など祝日じゃなくても休日ダイヤの時があるし
	// perlで作る。
	// 外部のファイルを読み込んで処理
	// PalmのTrainTimeの祝日ファイル形式
	// var returnnum = hogehoge(myMM,myDD);
	// wkd(1,2,3,4,5,weekday),hol(7,holiday),sun(0,sunday),sat(6,saturday)
	// なんかファイルの読み書きしなくちゃと思っていたけど、
	// 祝日ファイルをgrep -cして0じゃなかったら祝日だ。
	// 一行ですんだ(笑)
	var returnnum = wday.getDay();	// まずは本日の曜日を取得
	var myMM = wday.getMonth() + 1;
	var myDD = wday.getDate();
	if ( myMM < 10 ){ myMM = " " + myMM;};
	if ( myDD < 10 ){ myDD = " " + myDD;};
	var command = "grep -c '" + myMM + "/" + myDD + ":' HOLIDAY.txt" ;
	var ds_holiday = widget.system(command,null).outputString ;
	if ( ds_holiday > 0 ){ returnnum = 7 ;};
	// お盆休みとかで強制的に祝日データに切り替える時用
	// この値はpreferenceForKeyで持ってくる。全部共通だろうから
	var ds_forceholiday = widget.preferenceForKey("ds_forcehol"); 
	if ( ds_forceholiday > 0 ){ returnnum = 7 ;};
	return returnnum ;
}

function daycolor(wday)
{
	// 曜日によってタイトルの前の四角の色を変更するバカ処理
	// font の色を返す
	// 日曜0は赤 , 月1〜金5は青 , 土曜6は緑
	// 祝日7は赤 国旗も入れる？
	var colorstr = "#FFFFFF";	 // White
	
	if( wday == 7 ){				// Holiday Red
		colorstr = "#FF0000" ;
	}else if( wday == 0 ){		// Sunday Red
		colorstr = "#FF0000" ;	
	}else if( wday == 6 ){		// Saturday Green
		colorstr = "#33CC33" ;	
	}else{	// weekday Blue
		colorstr = "#0000FF" ;	
	};
	// 
	return colorstr ;
}

function daystr(wday)
{
	// 曜日によってタイトルの前の四角のとこに文字を
	// 日曜0はSUN , 月1〜金5はMON.TUE,,,, 土曜6はSAT
	// 祝日7はHOL
	if(wday > 7){ wday = 7 ; };
	var dayarray = new Array("SUN","MON","TUE","WED","THU","FRI","SAT","HOL");
	return dayarray[wday] ;
}


function traincolor(train)
{
	// 列車の種別によってフォントの色を変更するバカ処理
	// font の色を返す
	// 快速、通勤快速などは青
	// 急行、準急などはピンク
	// 特急、準特急などは赤
	// 特急は赤バックに白抜きにしたいのでそのうち変更予定
	var kaisoku = "快";
	var kyuko = "急";
	var tokkyu = "特";
	var colorstr = "#FFFFFF";	 // White
	if(train.indexOf(kyuko,0) >= 0){
		colorstr = "#FF0000";	 // Red
	};
	if(train.indexOf(tokkyu,0) >= 0){
		colorstr = "#FF0000";	 // White 
	};
	if(train.indexOf(kaisoku,0) >= 0){
		colorstr = "#0000FF";	 // Blue
	};
	return colorstr ;
}

